<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Subscription_Controller
{
  private $user_id, $subscriber_id;
  private $subscription_id;
  public $UAI_SUBSCRIPTION;
  public function __construct()
  {
    add_action('wp_ajax_create_subscription_plan', [$this, 'create_subscription_pack']);
    add_action('wp_ajax_get_subscription_plan', [$this, 'get_subscription_pack']);
    add_action('wp_ajax_delete_subscription_plan', [$this, 'delete_subscription_plan']);
    add_action('wp_ajax_update_subscription_status', [$this, 'update_subscription_status']);
    add_action('wp_ajax_package_name_handler', [$this, 'package_name_handler']);
    add_action('wp_ajax_package_pricing_handler', [$this, 'package_pricing_handler']);
    add_action('wp_ajax_sort_subscription_plan', [$this, 'sort_subscription_plan']);

    add_action('wp_ajax_cancel_subscription', [$this, 'cancel_subscription']);

    $this->UAI_SUBSCRIPTION = new Ultimate_AI_Subscription();
  }

  public function cancel_subscription()
  {
    $order_id = Ultimate_AI_Filter_Controller($_POST['order_id']);

    $meta = get_post_meta($order_id, 'ultimate_ai_order_meta', true);

    $meta['order_post_id'] = $order_id;
    $meta['subscribed'] = false;
    $meta['expiry'] = time();
    $meta['payment_status'] = 'cancel';

    $cancelled = $this->UAI_SUBSCRIPTION->updateSubcriptionStatus('CANCEL', $meta);

    if ($cancelled) {
      $res = [
        'status' => 200,
        'message' => esc_html__('Your current subscription plan is cancelled.', ULTIMATE_AI_SLUG)
      ];
    } else {
      $res = [
        'status' => 401,
        'message' => esc_html__('Subscription plan cancellation failed.', ULTIMATE_AI_SLUG)
      ];
    }

    wp_send_json($res, 200);
  }

  public function sort_subscription_plan()
  {
    $packs = Ultimate_AI_Filter_Controller($_POST['plans']);

    $updated = update_option('ultimate_ai_subscription_packs', $packs);

    wp_send_json(['updated' => $updated], 200);
  }
  // KEEP
  public function create_subscription_pack()
  {
    restrict_req_for_admin();

    $data = Ultimate_AI_Filter_Controller($_POST['data']);

    $res = $this->UAI_SUBSCRIPTION->create_subscription_pack($data);

    wp_send_json($res, 200);
  }

  // KEEP
  public function get_subscription_pack()
  {
    $plans = $this->UAI_SUBSCRIPTION->get_subscriptions();
    wp_send_json($plans, 200);
  }
  // KEEP
  public function update_subscription_status()
  {
    restrict_req_for_admin();
    $planid = Ultimate_AI_Filter_Controller($_POST['planid']);
    $res = $this->UAI_SUBSCRIPTION->update_subscription_pack_status($planid);
    wp_send_json($res, 200);
  }
  // KEEP
  public function delete_subscription_plan()
  {
    restrict_req_for_admin();
    $planid = Ultimate_AI_Filter_Controller($_POST['planid']);
    $res = $this->UAI_SUBSCRIPTION->delete_subscription_pack($planid);
    wp_send_json($res, 200);
  }

  public function package_pricing_handler()
  {
    $data = Ultimate_AI_Filter_Controller($_POST['data']);
    if ($data['type'] == 'subscription' && $data['free'] != 'true') {
      $res = $this->UAI_SUBSCRIPTION->paymentProcessorHandlePricing($data);
    } else {
      $res = [
        'status' => 200,
        'next_step' => true
      ];
    }
    wp_send_json($res, 200);
  }

  public function package_name_handler()
  {
    $data = Ultimate_AI_Filter_Controller($_POST['data']);

    if ($data['type'] == 'subscription') {
      $res = $this->UAI_SUBSCRIPTION->paymentProcessorHandlePackName($data);
    } else {
      $res = [
        'next_step' => true
      ];
    }

    wp_send_json($res, 200);
  }
}
new Ultimate_AI_Subscription_Controller();
